/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seplatform.platformdefinition;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.j2seplatform.platformdefinition.jrtfs.NBJRTUtil;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Utilities;

public class Util {
    public static final String PROTO_HTTP = "http";
    public static final String PROTO_HTTPS = "https";
    public static final String PROTO_FILE = "file";
    private static final String JFXRT_PATH = "lib/jfxrt.jar";
    private static final String MODULES_FOLDER = "modules";
    private static final String MODULE_INFO = "module-info.class";
    private static final SpecificationVersion OLD_JDK9 = new SpecificationVersion("1.9");
    public static final SpecificationVersion JDK9 = new SpecificationVersion("9");
    private static final Logger LOG = Logger.getLogger(Util.class.getName());
    private static final Set<String> propertiesToFix;
    private static final List<Function<FileObject, FileObject>> TOOLS_VARIANTS;

    private Util() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    static ClassPath createClassPath(@NonNull String classpath) {
        Parameters.notNull((CharSequence)"classpath", (Object)classpath);
        ArrayList list = new ArrayList();
        Util.addPath(classpath, list);
        return ClassPathSupport.createClassPath(list);
    }

    @CheckForNull
    static ClassPath createModulePath(@NonNull Collection<FileObject> installFolders) {
        ArrayList<PathResourceImplementation> modules = new ArrayList<PathResourceImplementation>();
        for (FileObject installFolder : installFolders) {
            URI imageURI;
            File installDir = FileUtil.toFile((FileObject)installFolder);
            URI uRI = imageURI = installDir == null ? null : NBJRTUtil.getImageURI(installDir);
            if (imageURI != null) {
                try {
                    FileObject root = Util.getModulesRoot(URLMapper.findFileObject((URL)imageURI.toURL()));
                    for (FileObject module : root.getChildren()) {
                        modules.add(ClassPathSupport.createResource((URL)module.toURL()));
                    }
                    break;
                }
                catch (MalformedURLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    break;
                }
            }
            FileObject modulesFolder = installFolder.getFileObject(MODULES_FOLDER);
            if (modulesFolder == null) continue;
            Arrays.stream(modulesFolder.getChildren()).filter(fo -> fo.isFolder() && fo.getFileObject(MODULE_INFO) != null).map(fo -> ClassPathSupport.createResource((URL)fo.toURL())).forEach(modules::add);
        }
        return modules.isEmpty() ? null : ClassPathSupport.createClassPath(modules);
    }

    @CheckForNull
    static URL getRootURL(@NonNull File f) {
        try {
            URL url = Utilities.toURI((File)f).toURL();
            if (FileUtil.isArchiveFile((URL)url)) {
                url = FileUtil.getArchiveRoot((URL)url);
            } else if (!f.exists()) {
                String surl = url.toExternalForm();
                if (!surl.endsWith("/")) {
                    url = new URL(surl + "/");
                }
            } else if (f.isFile()) {
                try {
                    ZipFile z = new ZipFile(f);
                    z.close();
                    url = FileUtil.getArchiveRoot((URL)url);
                }
                catch (IOException e) {
                    url = null;
                }
            }
            return url;
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String normalizeName(String displayName) {
        StringBuilder normalizedName = new StringBuilder();
        for (int i = 0; i < displayName.length(); ++i) {
            char c = displayName.charAt(i);
            if (Character.isJavaIdentifierPart(c) || c == '-' || c == '.') {
                normalizedName.append(c);
                continue;
            }
            normalizedName.append('_');
        }
        return normalizedName.toString();
    }

    public static SpecificationVersion getSpecificationVersion(JavaPlatform plat) {
        String version = (String)plat.getSystemProperties().get("java.specification.version");
        return Util.getSpecificationVersion(version);
    }

    public static SpecificationVersion getSpecificationVersion(String version) {
        if (version == null) {
            version = "1.1";
        }
        return Util.fixJDK9SpecVersion(Util.makeSpec(version));
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders) {
        return Util.findTool(toolName, installFolders, null);
    }

    public static FileObject findTool(String toolName, Collection<FileObject> installFolders, String archFolderName) {
        assert (toolName != null);
        return installFolders.stream().flatMap(f -> TOOLS_VARIANTS.stream().map(p -> (FileObject)p.apply(f))).filter(f -> f != null).map(f -> archFolderName != null ? f.getFileObject(archFolderName) : f).filter(f -> f != null).map(f -> f.getFileObject(toolName, Utilities.isWindows() ? "exe" : null)).filter(f -> f != null).findFirst().orElse(null);
    }

    public static String getExtensions(String extPath) {
        if (extPath == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer tk = new StringTokenizer(extPath, File.pathSeparator);
        while (tk.hasMoreTokens()) {
            File extFolder = FileUtil.normalizeFile((File)new File(tk.nextToken()));
            File[] files = extFolder.listFiles();
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.exists()) {
                    LOG.log(Level.WARNING, NbBundle.getMessage(Util.class, (String)"MSG_BrokenExtension"), new Object[]{f.getName(), extFolder.getAbsolutePath()});
                    continue;
                }
                if (Utilities.isMac() && "._.DS_Store".equals(f.getName())) continue;
                FileObject fo = FileUtil.toFileObject((File)f);
                if (fo == null) {
                    LOG.log(Level.WARNING, "Cannot create FileObject for file: {0} exists: {1}", new Object[]{f.getAbsolutePath(), f.exists()});
                    continue;
                }
                if (!FileUtil.isArchiveFile((FileObject)fo)) continue;
                sb.append(File.pathSeparator);
                sb.append(files[i].getAbsolutePath());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.substring(File.pathSeparator.length());
    }

    public static boolean isRemote(@NonNull URL url) {
        Parameters.notNull((CharSequence)"url", (Object)url);
        return Util.isRemoteProtocol(url.getProtocol());
    }

    public static boolean isRemoteProtocol(@NonNull String protocol) {
        Parameters.notNull((CharSequence)"protocol", (Object)protocol);
        return PROTO_HTTP.equals(protocol) || PROTO_HTTPS.equals(protocol);
    }

    /*
     * WARNING - void declaration
     */
    @NullUnknown
    public static String fixSymLinks(@NonNull String key, @NullAllowed String value, @NonNull Collection<? extends FileObject> installFolders) {
        if (value != null && propertiesToFix.contains(key)) {
            try {
                String[] pathElements = value.split(File.pathSeparator);
                boolean changed = false;
                for (FileObject fileObject : installFolders) {
                    String canonicalPath;
                    String path;
                    File f = FileUtil.toFile((FileObject)fileObject);
                    if (f == null || (path = f.getAbsolutePath()).equals(canonicalPath = f.getCanonicalPath())) continue;
                    for (int i = 0; i < pathElements.length; ++i) {
                        if (!pathElements[i].startsWith(canonicalPath)) continue;
                        pathElements[i] = path + pathElements[i].substring(canonicalPath.length());
                        changed = true;
                    }
                }
                if (changed) {
                    void var6_9;
                    StringBuilder sb = new StringBuilder();
                    boolean bl = false;
                    while (var6_9 < pathElements.length) {
                        if (var6_9 > 0) {
                            sb.append(File.pathSeparatorChar);
                        }
                        sb.append(pathElements[var6_9]);
                        ++var6_9;
                    }
                    return sb.toString();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return value;
    }

    public static String removeNBArtifacts(@NonNull String key, @NullAllowed String value) {
        Object nbHome;
        if (value != null && "java.class.path".equals(key) && (nbHome = System.getProperty("netbeans.home")) != null) {
            if (!((String)nbHome).endsWith(File.separator)) {
                nbHome = (String)nbHome + File.separatorChar;
            }
            String[] elements = PropertyUtils.tokenizePath((String)value);
            ArrayList<String> newElements = new ArrayList<String>(elements.length);
            for (String element : elements) {
                if (element.startsWith((String)nbHome)) continue;
                newElements.add(element);
            }
            if (elements.length != newElements.size()) {
                value = newElements.stream().collect(Collectors.joining(File.pathSeparator));
            }
        }
        return value;
    }

    @NonNull
    public static Collection<FileObject> toFileObjects(Collection<? extends URL> urls) {
        if (urls.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<FileObject> result = new ArrayList<FileObject>(urls.size());
        for (URL uRL : urls) {
            FileObject fo = URLMapper.findFileObject((URL)uRL);
            if (fo == null) continue;
            result.add(fo);
        }
        return result;
    }

    @NullUnknown
    public static Map<String, String> filterProbe(@NullAllowed Map<String, String> p, @NullAllowed String probePath) {
        String val;
        if (p != null && (val = p.get("java.class.path")) != null) {
            p.put("java.class.path", Util.filterProbe(val, probePath));
        }
        return p;
    }

    private static String filterProbe(String v, String probePath) {
        if (v != null) {
            String[] pes = PropertyUtils.tokenizePath((String)v);
            StringBuilder sb = new StringBuilder();
            for (String pe : pes) {
                if (probePath == null ? pe != null && pe.endsWith("org-netbeans-modules-java-j2seplatform-probe.jar") : probePath.equals(pe)) continue;
                if (sb.length() > 0) {
                    sb.append(File.pathSeparatorChar);
                }
                sb.append(pe);
            }
            v = sb.toString();
        }
        return v;
    }

    private static SpecificationVersion makeSpec(String vers) {
        if (vers != null) {
            try {
                return new SpecificationVersion(vers);
            }
            catch (NumberFormatException nfe) {
                System.err.println("WARNING: invalid specification version: " + vers);
                while (true) {
                    vers = vers.substring(0, vers.length() - 1);
                    try {
                        return new SpecificationVersion(vers);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (vers.length() > 0) continue;
                    }
                    break;
                }
            }
        }
        return new SpecificationVersion("0");
    }

    private static SpecificationVersion fixJDK9SpecVersion(@NonNull SpecificationVersion version) {
        return OLD_JDK9.equals((Object)version) ? JDK9 : version;
    }

    @CheckForNull
    private static PathResourceImplementation getJfxRt(@NonNull Collection<? extends FileObject> installFolders) {
        for (FileObject fileObject : installFolders) {
            FileObject jfxrt = fileObject.getFileObject(JFXRT_PATH);
            if (jfxrt == null || !FileUtil.isArchiveFile((FileObject)jfxrt)) continue;
            return ClassPathSupport.createResource((URL)FileUtil.getArchiveRoot((URL)jfxrt.toURL()));
        }
        return null;
    }

    private static void addPath(@NullAllowed String path, @NonNull List<? super PathResourceImplementation> into) {
        if (path != null && !path.isEmpty()) {
            StringTokenizer tokenizer = new StringTokenizer(path, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String item = tokenizer.nextToken();
                File f = FileUtil.normalizeFile((File)new File(item));
                URL url = Util.getRootURL(f);
                if (url == null) continue;
                into.add((PathResourceImplementation)ClassPathSupport.createResource((URL)url));
            }
        }
    }

    @NonNull
    private static FileObject getModulesRoot(@NonNull FileObject jrtRoot) {
        FileObject modules = jrtRoot.getFileObject(MODULES_FOLDER);
        return modules == null ? jrtRoot : modules;
    }

    static {
        HashSet<String> p = new HashSet<String>();
        p.add("sun.boot.class.path");
        p.add("sun.boot.library.path");
        p.add("java.library.path");
        p.add("java.ext.dirs");
        p.add("java.home");
        p.add("java.endorsed.dirs");
        propertiesToFix = Collections.unmodifiableSet(p);
        ArrayList<Function<FileObject, FileObject>> l = new ArrayList<Function<FileObject, FileObject>>();
        l.add(installFolder -> installFolder.getFileObject("bin"));
        l.add(installFolder -> installFolder.getFileObject("jdk/bin"));
        TOOLS_VARIANTS = Collections.unmodifiableList(l);
    }
}

